/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jtbcore.util.AppLogger;
import jtbcore.util.StringUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class RequestUrl {
    protected String url;
    protected String requestData = null;
    protected Map<String, String> requestParams = null;
    protected Map<String, File> requestFiles = null;
    protected Map<String, byte[]> requestBinaries = null;
    protected Map<String, String> requestHeaders = null;
    protected HttpURLConnection ucon = null;
    protected String responseData = null;
    protected Integer connectTimeout = 5000;
    protected Integer readTimeout = 5000;

    public RequestUrl(String url) {
        this.setUrl(url);
        this.requestHeaders = new HashMap<String, String>();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public void setRequestData(String data) {
        this.requestData = data;
    }

    public void setRequestHeader(String k, String v) {
        this.requestHeaders.put(k, v);
    }

    public void setRequestParam(String k, String v) {
        if (this.requestParams == null) {
            this.requestParams = new HashMap<String, String>();
        }
        if (v == null) {
            v = "";
        }
        this.requestParams.put(k, v);
    }

    public void setRequestFile(String k, File f) {
        if (this.requestFiles == null) {
            this.requestFiles = new HashMap<String, File>();
        }
        this.requestFiles.put(k, f);
    }

    public void setRequestBinary(String filename, byte[] data) {
        if (this.requestBinaries == null) {
            this.requestBinaries = new HashMap<String, byte[]>();
        }
        this.requestBinaries.put(filename, data);
    }

    public String getResponseData() {
        return this.responseData;
    }

    public void setResponseData(String responseData) {
        this.responseData = responseData;
    }

    public String getHeadersAsText() {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getURLConnection().getResponseMessage()).append("\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Map<String, List<String>> headers = this.getURLConnection().getHeaderFields();
        for (String headerName : headers.keySet()) {
            List<String> vals = headers.get(headerName);
            for (String v : vals) {
                if (headerName == null) {
                    buf.append(v).append("\n");
                    continue;
                }
                buf.append(headerName).append(": ").append(v).append("\n");
            }
        }
        return buf.toString();
    }

    public HttpURLConnection getURLConnection() {
        return this.ucon;
    }

    public void get() throws IOException, URISyntaxException {
        URI uri = new URI(this.url);
        URL u = uri.toURL();
        this.ucon = (HttpURLConnection)u.openConnection();
        this.ucon.setConnectTimeout(this.connectTimeout);
        this.ucon.setReadTimeout(this.readTimeout);
        this.ucon.setRequestMethod("GET");
        for (String headerName : this.requestHeaders.keySet()) {
            this.ucon.setRequestProperty(headerName, this.requestHeaders.get(headerName));
        }
        this.ucon.setUseCaches(false);
        this.ucon.connect();
        try {
            InputStream is = this.ucon.getInputStream();
            this.responseData = StringUtil.inputStream2String(is);
            is.close();
        }
        catch (IOException ex) {
            try {
                InputStream is2 = this.ucon.getErrorStream();
                this.responseData = StringUtil.inputStream2String(is2);
                if (this.responseData != null && this.responseData.length() > 0) {
                    AppLogger.error("Invalid response: " + this.responseData);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        this.ucon.disconnect();
    }

    public void post() throws IOException, URISyntaxException {
        URI uri = new URI(this.url);
        URL u = uri.toURL();
        this.ucon = (HttpURLConnection)u.openConnection();
        this.ucon.setConnectTimeout(this.connectTimeout);
        this.ucon.setReadTimeout(this.readTimeout);
        this.ucon.setRequestMethod("POST");
        for (String headerName : this.requestHeaders.keySet()) {
            this.ucon.setRequestProperty(headerName, this.requestHeaders.get(headerName));
        }
        this.ucon.setUseCaches(false);
        this.ucon.setDoOutput(true);
        this.ucon.connect();
        OutputStream os = this.ucon.getOutputStream();
        if (this.requestParams != null) {
            StringBuilder b = new StringBuilder();
            for (String k : this.requestParams.keySet()) {
                String val = this.requestParams.get(k);
                k = URLEncoder.encode(k, "UTF-8");
                if (val != null) {
                    val = URLEncoder.encode(val, "UTF-8");
                }
                if (b.length() > 0) {
                    b.append("&");
                }
                b.append(k);
                b.append("=");
                b.append(val);
            }
            os.write(b.toString().getBytes("UTF-8"));
        } else if (this.requestData != null) {
            os.write(this.requestData.getBytes());
        }
        os.close();
        InputStream is = this.ucon.getInputStream();
        this.responseData = StringUtil.inputStream2String(is);
        is.close();
        this.ucon.disconnect();
    }

    public void postMultipart() {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost request = new HttpPost(this.url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (this.requestFiles != null) {
            for (String s : this.requestFiles.keySet()) {
                try {
                    File f = this.requestFiles.get(s);
                    builder.addBinaryBody(s, (InputStream)new FileInputStream(f), ContentType.APPLICATION_OCTET_STREAM, f.getName());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.requestBinaries != null) {
            for (String s : this.requestBinaries.keySet()) {
                try {
                    builder.addBinaryBody(s, this.requestBinaries.get(s), ContentType.APPLICATION_OCTET_STREAM, s);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.requestParams != null) {
            for (String s : this.requestParams.keySet()) {
                builder.addTextBody(s, this.requestParams.get(s));
            }
        }
        HttpEntity multipart = builder.build();
        request.setEntity(multipart);
        try {
            Object object = null;
            Object var6_8 = null;
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                this.responseData = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                throw object;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            RequestUrl u = new RequestUrl("https://www.itxplain.nl/test123.php");
            u.setRequestData("blalbala");
            u.post();
            System.out.println(u.getResponseData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

